<?php

   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $query = "SELECT * FROM geecB_impostazioniLingue WHERE id=1";
    $risImpostazioniLingue = $geecomDb->eseguiQueryLettura($query);
    $impostazioniLingue = $risImpostazioniLingue->fetch_assoc();

    $arrayLingue["italiano"] = $impostazioniLingue["impostazioniItaliano"];
    $arrayLingue["inglese"] = $impostazioniLingue["impostazioniInglese"];
    $arrayLingue["tedesco"] = $impostazioniLingue["impostazioniTedesco"];
    $arrayLingue["francese"] = $impostazioniLingue["impostazioniFrancese"];
    $arrayLingue["spagnolo"] = $impostazioniLingue["impostazioniSpagnolo"];

    $menuLingue["italiano"] = $impostazioniLingue["menuItaliano"];
    $menuLingue["inglese"] = $impostazioniLingue["menuInglese"];
    $menuLingue["tedesco"] = $impostazioniLingue["menuTedesco"];
    $menuLingue["francese"] = $impostazioniLingue["menuFrancese"];
    $menuLingue["spagnolo"] = $impostazioniLingue["menuSpagnolo"];

    if(isset($contenuto)) {
        $linguaCorrente = $contenuto["linguaContenuto"];
    }
    else if(isset($categoria)) {
        $linguaCorrente = $categoria["lingua"];
    }
    else if(isset($prodotto)) {
        $linguaCorrente = $prodotto["lingua"];
    }
    else {
        $impostazioni["linguaSito"];
    }
?>
<ul class="navbar-nav mr-auto ml-0 selettore-lingue">
    <li class="nav-item dropdown">
        <a class="nav-link dropdown-toggle" href="#" id="dropdown-lingue" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <img class="img-fluid" src="<?php echo percorsoImmagineBandiera($linguaCorrente); ?>">
        </a>
        <div class="dropdown-menu dropdown-menu-sm-right" aria-labelledby="dropdown-lingue">
            <?php 
                foreach($arrayLingue as $nome=>$attiva) {
                    if($attiva=="si") {
                        $bandiera = percorsoImmagineBandiera($nome);

                        if(isset($contenuto) && $contenuto["tipo"]=="elementoPortfolio") { // elemento portfolio
                            $linkContenutoTradotto = linkElementoPorfolioTradotto($geecomDb, $impostazioni, $contenuto, $nome);
                        }
                        else if(isset($contenuto)) {
                            $linkContenutoTradotto = linkContenutoTradotto($geecomDb, $impostazioni, $contenuto, $nome);
                        }
                        else if(isset($categoria)) { // si trova in una categoria
                            $linkContenutoTradotto = linkCategoriaTradotta($geecomDb, $impostazioni, $categoria, $nome);
                        }
                        else if(isset($prodotto)) { // si trova in un prodotto
                            $linkContenutoTradotto = linkProdottoTradotto($geecomDb, $impostazioni, $prodotto, $nome);
                        }
                        else {
                            $linkContenutoTradotto = $impostazioni["urlSito"];
                        }
                        if($linkContenutoTradotto!="#") {
                            echo"<a class=\"dropdown-item text-center\" href=\"{$linkContenutoTradotto}\">
                                <img class=\"img-fluid\" src=\"$bandiera\">
                            </a>";
                        }
                    }
                }
            ?>
        </div>
    </li>
</ul>